@echo off

rem %1  The name for the PK4 file (without the extension)
rem %2  The full path to the folder containing gamex86.dll
rem %3  The full path of gamex86.dll

setlocal ENABLEEXTENSIONS

    set ModPakFile=

    set pk4=%~1.pk4
    set wrk=%~2

    pushd %wrk%

        rem ---------------------------------------------
        rem A gamecode PK4 file needs binary.conf to tell
        rem Doom3.exe which operating system it is for
        rem ---------------------------------------------

        echo // Windows > binary.conf
        echo 0 >> binary.conf

        rem ------------------------------
        rem Delete any existing PK4 file
        rem ------------------------------

        del %pk4% /Q /F >nul 2>&1

        rem -----------------------
        rem Create the new PK4 file
        rem -----------------------

        rem ----------------------------
        rem 7-Zip: http://www.7-zip.org/
        rem ----------------------------

        if exist "%ProgramFiles%\7-Zip\7z.exe" (
            "%ProgramFiles%\7-Zip\7z.exe" -tzip a %pk4% %3 binary.conf >zip.out 2>&1
            goto :Created
        )

        if exist "%ProgramFiles%\7-Zip\7za.exe" (
            "%ProgramFiles%\7-Zip\7za.exe" -tzip a %pk4% %3 binary.conf >zip.out 2>&1
            goto :Created
        )

        rem ------------------------------
        rem WinZip: http://www.winzip.com/
        rem ------------------------------

        if exist "%ProgramFiles%\winzip\wzzip.exe" (
            "%ProgramFiles%\winzip\wzzip.exe" %pk4% %3 binary.conf >zip.out 2>&1
            goto :Created
        )

        rem -------------------------------
        rem WinRAR: http://www.rarlabs.com/
        rem -------------------------------

        if exist "%ProgramFiles%\WinRAR\WinRAR.exe" (
            "%ProgramFiles%\WinRAR\WinRAR.exe" a -afzip -ep %pk4% %3 binary.conf >zip.out 2>&1
            goto :Created
        )

        echo *************************************************
        echo WARNING: No utility program found to create %pk4%
        echo *************************************************

        goto :Done

        :Created
        if exist "%pk4%" (
            echo PK4 file created.
        ) else (
            echo PK4 file NOT created!
            type zip.out
            goto :Done
        )


        rem ------------------------------------------
        rem Copy the new PK4 to the main mod directory
        rem ------------------------------------------
        if "%ModPakFile%" NEQ "" (
            echo Copying %pk4% to "%ModPakFile%"
            copy %pk4% "%ModPakFile%" /Y
        )

        :Done
        rem ----------------------------------------------
        rem binary.conf isn't needed once it is in the PK4
        rem ----------------------------------------------
        del binary.conf /Q /F >nul 2>&1
        del zip.out /Q /F >nul 2>&1

    popd

endlocal
